/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskScopePane;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class VWTaskScopeTree
extends JTree
implements ActionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private VWTaskBaseNode m_focus = null;
    private VWTaskScopePane m_scopePane = null;
    private DragSource m_dragSource = null;
    private TreePath m_activeDragPath = null;
    private boolean m_bHasApplicationFocus = true;

    public VWTaskScopeTree(TreeModel treeModel, VWTaskScopePane scopeViewPane) {
        super(treeModel);
        this.m_focus = (VWTaskBaseNode)treeModel.getRoot();
        this.m_scopePane = scopeViewPane;
        this.m_dragSource = DragSource.getDefaultDragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this);
        this.addMouseListener(new VWTaskTreeMouseListener());
        this.getAccessibleContext().getAccessibleSelection().addAccessibleSelection(0);
        VWAccessibilityHelper.setAccessibility(this, scopeViewPane, VWResource.ProcessTaskManagerTree, VWResource.ProcessTaskManagerTree);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        this.m_scopePane.actionPerformed(event);
    }

    protected void refresh() {
        this.revalidate();
        this.repaint();
        this.updateUI();
        this.setSelectionPath(new TreePath(this.m_focus.getPath()));
    }

    protected void setFocus(VWTaskBaseNode node) {
        this.m_focus = node;
    }

    protected VWTaskBaseNode getFocus() {
        return this.m_focus;
    }

    protected void setHasApplicationFocus(boolean hasFocus) {
        this.m_bHasApplicationFocus = hasFocus;
    }

    protected boolean hasApplicationFocus() {
        return this.m_bHasApplicationFocus;
    }

    private class VWTaskTreeMouseListener
    extends MouseAdapter {
        private VWTaskTreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = VWTaskScopeTree.this.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = VWTaskScopeTree.this.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                VWTaskBaseNode nodeClicked = (VWTaskBaseNode)selPath.getLastPathComponent();
                if (!VWTaskScopeTree.this.m_bHasApplicationFocus && nodeClicked == VWTaskScopeTree.this.m_focus) {
                    TreeSelectionEvent event = new TreeSelectionEvent((Object)this, selPath, true, selPath, selPath);
                    VWTaskScopeTree.this.fireValueChanged(event);
                }
            }
        }
    }
}

